/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.object;

import java.util.Map;
import net.sf.snmpadaptor4j.object.GenericSnmpTrapType;
import net.sf.snmpadaptor4j.object.SnmpOid;
import net.sf.snmpadaptor4j.object.SnmpTrap;
import net.sf.snmpadaptor4j.object.SnmpTrapData;
import org.apache.log4j.Logger;

public final class GenericSnmpTrap
extends SnmpTrap {
    private static final long serialVersionUID = -6485304599608042063L;
    private final GenericSnmpTrapType type;

    protected GenericSnmpTrap(long timeStamp, SnmpOid source, GenericSnmpTrapType type, Map<SnmpOid, SnmpTrapData> dataMap) {
        super(timeStamp, source, dataMap);
        this.type = type;
    }

    public GenericSnmpTrapType getType() {
        return this.type;
    }

    @Override
    public void traceTo(Logger logger) {
        logger.trace((Object)("enterprise         = " + this.getSource()));
        logger.trace((Object)("generic-trap       = " + (Object)((Object)this.type)));
        logger.trace((Object)"specific-trap      = 0");
        logger.trace((Object)("time-stamp         = " + this.getTimeStamp()));
        for (Map.Entry<SnmpOid, SnmpTrapData> data : this.getDataMap().entrySet()) {
            logger.trace((Object)("variable-bindings: " + data.getKey() + " = " + data.getValue()));
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = false;
        if (obj == this) {
            result = true;
        } else {
            result = super.equals(obj);
            if (result) {
                GenericSnmpTrap other = (GenericSnmpTrap)obj;
                result = this.type == other.type;
            }
        }
        return result;
    }

    public String toString() {
        return "SNMP trap " + this.getSource() + " - Type " + (Object)((Object)this.type) + "/0";
    }
}

