/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.object;

import java.io.Serializable;
import java.util.Arrays;
import java.util.StringTokenizer;

public final class SnmpOid
implements Comparable<SnmpOid>,
Serializable {
    private static final long serialVersionUID = -1099844003876586949L;
    public static SnmpOid SYSNAME_OID = SnmpOid.newInstance(new int[]{1, 3, 6, 1, 2, 1, 1, 5, 0});
    public static SnmpOid SYSDESCR_OID = SnmpOid.newInstance(new int[]{1, 3, 6, 1, 2, 1, 1, 1, 0});
    public static SnmpOid SYSLOCATION_OID = SnmpOid.newInstance(new int[]{1, 3, 6, 1, 2, 1, 1, 6, 0});
    public static SnmpOid SYSCONTACT_OID = SnmpOid.newInstance(new int[]{1, 3, 6, 1, 2, 1, 1, 4, 0});
    public static SnmpOid SYSUPTIME_OID = SnmpOid.newInstance(new int[]{1, 3, 6, 1, 2, 1, 1, 3, 0});
    private final int[] oid;

    public static SnmpOid newInstance(String oid, int nodeNum, int index) {
        StringTokenizer tokens = new StringTokenizer(oid.trim(), ".");
        int[] array = new int[tokens.countTokens() + 2];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            array[i] = Integer.parseInt(tokens.nextToken());
            ++i;
        }
        array[i] = nodeNum;
        array[i + 1] = index;
        return new SnmpOid(array);
    }

    public static SnmpOid newInstance(SnmpOid oid, int nodeNum, int index) {
        int[] array = new int[oid.oid.length + 2];
        for (int i = 0; i < oid.oid.length; ++i) {
            array[i] = oid.oid[i];
        }
        array[oid.oid.length] = nodeNum;
        array[oid.oid.length + 1] = index;
        return new SnmpOid(array);
    }

    public static SnmpOid newInstance(String oid) {
        StringTokenizer tokens = new StringTokenizer(oid.trim(), ".");
        int[] array = new int[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            array[i] = Integer.parseInt(tokens.nextToken());
            ++i;
        }
        return new SnmpOid(array);
    }

    public static SnmpOid newInstance(int[] oid, int index) {
        int[] newOid = new int[oid.length + 1];
        for (int i = 0; i < oid.length; ++i) {
            newOid[i] = oid[i];
        }
        newOid[oid.length] = index;
        return new SnmpOid(newOid);
    }

    public static SnmpOid newInstance(int[] oid) {
        return new SnmpOid(oid);
    }

    private SnmpOid(int[] oid) {
        this.oid = oid;
    }

    public int[] getOid() {
        return this.oid;
    }

    public int getIndex() {
        return this.oid[this.oid.length - 1];
    }

    public int hashCode() {
        return Arrays.hashCode(this.oid);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj == this) {
            result = true;
        } else if (obj != null && this.getClass().equals(obj.getClass())) {
            result = Arrays.equals(this.oid, ((SnmpOid)obj).oid);
        }
        return result;
    }

    public boolean equalsWithoutIndex(SnmpOid other) {
        boolean result = false;
        if (other != null && other.oid.length == this.oid.length - 1) {
            result = true;
            for (int i = 0; i < other.oid.length && result; ++i) {
                result = other.oid[i] == this.oid[i];
            }
        }
        return result;
    }

    public boolean isRootOf(SnmpOid other) {
        boolean result = false;
        if (other != null && other.oid.length >= this.oid.length) {
            result = true;
            for (int i = 0; i < this.oid.length && result; ++i) {
                result = other.oid[i] == this.oid[i];
            }
        }
        return result;
    }

    @Override
    public int compareTo(SnmpOid obj) {
        int i;
        int result = 0;
        boolean compare = true;
        for (i = 0; i < this.oid.length && compare; ++i) {
            if (i < obj.oid.length) {
                if (this.oid[i] == obj.oid[i]) continue;
                result = this.oid[i] - obj.oid[i];
                compare = false;
                continue;
            }
            result = 1;
            compare = false;
        }
        if (compare && i < obj.oid.length) {
            result = -1;
        }
        return result;
    }

    public String toString() {
        String result = "";
        for (int num : this.oid) {
            result = result + "." + num;
        }
        return result;
    }
}

